"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var assert_1 = __importDefault(require("./utils/assert"));
var objectToGetParams_1 = __importDefault(require("./utils/objectToGetParams"));
var createShareButton_1 = __importDefault(require("./hocs/createShareButton"));
function twitterLink(url, _a) {
    var title = _a.title, via = _a.via, _b = _a.hashtags, hashtags = _b === void 0 ? [] : _b, _c = _a.related, related = _c === void 0 ? [] : _c;
    (0, assert_1.default)(url, 'twitter.url');
    (0, assert_1.default)(Array.isArray(hashtags), 'twitter.hashtags is not an array');
    (0, assert_1.default)(Array.isArray(related), 'twitter.related is not an array');
    return ('https://twitter.com/share' +
        (0, objectToGetParams_1.default)({
            url: url,
            text: title,
            via: via,
            hashtags: hashtags.length > 0 ? hashtags.join(',') : undefined,
            related: related.length > 0 ? related.join(',') : undefined,
        }));
}
var TwitterShareButton = (0, createShareButton_1.default)('twitter', twitterLink, function (props) { return ({
    hashtags: props.hashtags,
    title: props.title,
    via: props.via,
    related: props.related,
}); }, {
    windowWidth: 550,
    windowHeight: 400,
});
exports.default = TwitterShareButton;
